/*
 * Decompiled with CFR 0.152.
 */
package app;

import app.PlotDataXY;
import app.Sample;
import app.SingleShot;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import util.Logger;

public class RawDataSet {
    static Logger logger = Logger.getLogger();
    private List<Double> FreqList;
    private boolean isDatatypeAzimuth;
    private Map<Double, Map<Double, Sample>> TargetMap;

    public List<Double> getFreqList() {
        return this.FreqList;
    }

    public void setDatatypeAzimuth(boolean b) {
        this.isDatatypeAzimuth = b;
    }

    public RawDataSet() {
        logger.entry(4, "RawDataSet.RawDataSet");
        this.FreqList = new ArrayList<Double>();
        this.isDatatypeAzimuth = true;
        this.TargetMap = new TreeMap<Double, Map<Double, Sample>>();
        logger.exit(4, "RawDataSet.RawDataSet");
    }

    public boolean getReady() {
        return this.TargetMap.size() > 0;
    }

    public List<Double> getTargetList() {
        ArrayList<Double> result = new ArrayList<Double>();
        for (double t : this.TargetMap.keySet()) {
            result.add(t);
        }
        return result;
    }

    public void clear() {
        logger.entry(4, "RawDataSet.clear");
        this.FreqList.clear();
        this.TargetMap.clear();
        logger.exit(4, "RawDataSet.clear");
    }

    public double getActualBearing(double tg, double freq) {
        double result = 0.0;
        if (this.TargetMap.containsKey(tg) && this.TargetMap.get(tg).containsKey(freq)) {
            result = this.TargetMap.get(tg).get(freq).getSigAzi(this.isDatatypeAzimuth);
        }
        return result;
    }

    public void addShot(double t, double f, SingleShot sh) {
        if (this.TargetMap.containsKey(t)) {
            if (this.TargetMap.get(t).containsKey(f)) {
                Sample m = this.TargetMap.get(t).get(f);
                m.addShot(sh);
            } else {
                Sample m = new Sample(t, f);
                m.addShot(sh);
                this.TargetMap.get(t).put(f, m);
                if (!this.FreqList.contains(f)) {
                    this.FreqList.add(f);
                }
            }
        } else {
            Sample m = new Sample(t, f);
            m.addShot(sh);
            TreeMap<Double, Sample> fm = new TreeMap<Double, Sample>();
            fm.put(f, m);
            this.TargetMap.put(t, fm);
            if (!this.FreqList.contains(f)) {
                this.FreqList.add(f);
            }
        }
    }

    public double getGlobalRMS() {
        logger.entry(4, "RawDataSet.getGlobalRMS");
        int count = 0;
        double rms = 0.0;
        double delta = 0.0;
        Iterator<Double> it = this.TargetMap.keySet().iterator();
        while (it.hasNext()) {
            Map<Double, Sample> mfm = this.TargetMap.get(it.next());
            Iterator<Double> it2 = mfm.keySet().iterator();
            while (it2.hasNext()) {
                Sample m = mfm.get(it2.next());
                delta = m.getSigAzi(this.isDatatypeAzimuth) - m.getTarget();
                rms += delta * delta;
                ++count;
            }
        }
        rms = Math.sqrt(rms / (double)count);
        logger.exit(4, "RawDataSet.getGlobalRMS");
        return rms;
    }

    public double getRMSForTarget(double t) {
        logger.entry(4, "RawDataSet.getRMSforTarget");
        int count = 0;
        double rms = 0.0;
        Map<Double, Sample> mfm = this.TargetMap.get(t);
        for (double f : mfm.keySet()) {
            double delta = mfm.get(f).getSigAzi(this.isDatatypeAzimuth) - t;
            rms += delta * delta;
            ++count;
        }
        rms = Math.sqrt(rms / (double)count);
        logger.exit(4, "RawDataSet.getRMSForTarget " + rms);
        return rms;
    }

    public double getRMSForFreq(double freq) {
        logger.entry(4, "RawDataSet.getRMSforFreq");
        int count = 0;
        double rms = 0.0;
        for (double tg : this.TargetMap.keySet()) {
            Map<Double, Sample> mfm = this.TargetMap.get(tg);
            if (mfm.get(freq) == null) continue;
            double delta = mfm.get(freq).getSigAzi(this.isDatatypeAzimuth) - tg;
            rms += delta * delta;
            ++count;
        }
        rms = Math.sqrt(rms / (double)count);
        logger.exit(4, "RawDataSet.getRMSForFreq " + rms);
        return rms;
    }

    public double getRMS(double target, double freq) {
        logger.entry(4, "RawDataSet.getRMS");
        Map<Double, Sample> mfm = this.TargetMap.get(target);
        Sample m = mfm.get(freq);
        double rms = m.getSigAzi(this.isDatatypeAzimuth) - target;
        logger.exit(4, "RawDataSet.getRMS");
        return rms;
    }

    public PlotDataXY getAziDataForTarget(double t) {
        logger.entry(4, "RawDataSet.getAziDataForTarget");
        PlotDataXY result = new PlotDataXY();
        Map<Double, Sample> FreqMap = this.TargetMap.get(t);
        int n = 0;
        for (double k : FreqMap.keySet()) {
            result.addPoint(k, FreqMap.get(k).getSigAzi(this.isDatatypeAzimuth));
            ++n;
        }
        logger.exit(4, "RawDataSet.getAziDataForTarget, n = " + n);
        return result;
    }

    public PlotDataXY getAziDataForFreq(double f) {
        logger.entry(4, "RawDataSet.getAziDataForFreq");
        PlotDataXY result = new PlotDataXY();
        Iterator<Double> it = this.TargetMap.keySet().iterator();
        int n = 0;
        while (it.hasNext()) {
            double target = it.next();
            Map<Double, Sample> FreqMap = this.TargetMap.get(target);
            if (FreqMap.get(f) == null) continue;
            result.addPoint(target, FreqMap.get(f).getSigAzi(this.isDatatypeAzimuth));
            ++n;
        }
        logger.exit(4, "RawDataSet.getAziDataForFreq, n = " + n);
        return result;
    }

    public void getFitInput(List<Double> tgs, List<Double> azis, double freq) {
        for (double target : this.TargetMap.keySet()) {
            Map<Double, Sample> FreqMap = this.TargetMap.get(target);
            if (FreqMap.get(freq) == null) continue;
            tgs.add(target);
            azis.add(FreqMap.get(freq).getSigAzi(this.isDatatypeAzimuth));
        }
    }

    public void logFreqs() {
        for (double target : this.TargetMap.keySet()) {
            logger.log(5, "target = " + target);
        }
        Map<Double, Sample> FreqMap = this.TargetMap.get(10.0);
        for (double freq : FreqMap.keySet()) {
            Sample m = FreqMap.get(freq);
            logger.log(5, "freq = " + freq + " contains entr " + m.entries.size());
        }
    }
}

